/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.eventmon;

import com.ibm.hwmca.fw.eventmon.EventMonitor;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Iterator;
import java.util.Map;

public class MonitorSummaryBean
extends PanelBean
implements DataBean {
    private static final String TRACE_MASKT = "XLISTENT";
    private static final String TRACE_MASKF = "XLISTENF";
    private static final String TRACE_MASKD = "XLISTEND";
    private static final String THIS_CLASS = "MonitorSummaryBean";
    private String m_sSmtpServer;
    private double m_dSmtpPort;
    private double m_dMinimumSeconds;
    private ItemDescriptor[][] m_idMonitorList;
    private ColumnDescriptor[] m_cdMonitorListStructure;
    private int[] m_iMonitorListSelection;
    Map _monitors;

    public void setSmtpServer(String s) throws IllegalUserDataException {
        this.m_sSmtpServer = s;
    }

    public String getSmtpServer() {
        return this.m_sSmtpServer;
    }

    public void setSmtpPort(double d) throws IllegalUserDataException {
        this.m_dSmtpPort = d;
    }

    public double getSmtpPort() {
        return this.m_dSmtpPort;
    }

    public void setMinimumSeconds(double d) throws IllegalUserDataException {
        this.m_dMinimumSeconds = d;
    }

    public double getMinimumSeconds() {
        return this.m_dMinimumSeconds;
    }

    public void setMonitorListSelection(int[] selected) throws IllegalUserDataException {
        this.m_iMonitorListSelection = selected;
    }

    public int[] getMonitorListSelection() {
        return this.m_iMonitorListSelection;
    }

    public void setMonitorListRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idMonitorList[index] = items;
        String monitorName = items[0].getTitle();
        boolean enabled = items[2].getTitle().equals("true");
        EventMonitor existingMonitor = (EventMonitor)this._monitors.get(monitorName);
        if (existingMonitor != null && existingMonitor.isEnabled() != enabled) {
            PanelTaskletRequest req = new PanelTaskletRequest();
            req.setData("requestType", "setEnabled");
            req.setData("changedMonitor", existingMonitor);
            req.setData("enabled", new Boolean(enabled));
            this.postTaskletRequest(req);
        }
    }

    public ItemDescriptor[] getMonitorListRowAt(int index) {
        return this.m_idMonitorList[index];
    }

    public int getMonitorListRowCount() {
        return this.m_idMonitorList.length;
    }

    public int getMonitorListRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getMonitorListRowStructure() {
        return this.m_cdMonitorListStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.m_cdMonitorListStructure = new ColumnDescriptor[0];
    }

    public StringBuffer dump() {
        StringBuffer buff = new StringBuffer();
        EventMonitor.appendMember(buff, "m_sSmtpServer", this.getSmtpServer());
        EventMonitor.appendMember(buff, "m_dSmtpPort", this.getSmtpPort());
        EventMonitor.appendMember(buff, "m_dMinimumSeconds", this.getMinimumSeconds());
        return buff;
    }

    public void save() {
    }

    public void prepare() {
        this.updateMonitorList();
    }

    public void update(Object newData) {
        this._monitors = (Map)((Map)newData).get("monitors");
        this.updateMonitorList();
    }

    public void panelAction(TaskActionEvent event) {
        String originator = event.getElementName();
        if (originator.equals("CancelButton")) {
            this.dispose();
        } else {
            PanelTaskletRequest req = new PanelTaskletRequest();
            req.setData("requestType", "handleEvent");
            req.setData("event", event);
            EventMonitor selectedMonitor = null;
            int[] selected = this.getMonitorListSelection();
            if (selected != null && selected.length > 0) {
                int row = selected[0];
                String monitorName = this.getMonitorListRowAt(row)[0].getTitle();
                selectedMonitor = (EventMonitor)this._monitors.get(monitorName);
            }
            req.setData("selectedMonitor", selectedMonitor);
            req.setData("smtpHost", this.getSmtpServer());
            Trace.trace(TRACE_MASKF, "MonitorSummaryBean.panelAction:  smtpPort is " + this.getSmtpPort());
            req.setData("smtpPort", new Integer(new Double(this.getSmtpPort()).intValue()));
            req.setData("minSecs", new Integer(new Double(this.getMinimumSeconds()).intValue()));
            this.postTaskletRequest(req);
        }
    }

    void setMonitors(Map monitors) {
        this._monitors = monitors;
    }

    private void updateMonitorList() {
        int count = 0;
        this.m_idMonitorList = new ItemDescriptor[this._monitors.size()][3];
        Iterator i = this._monitors.values().iterator();
        while (i.hasNext()) {
            this.m_idMonitorList[count] = this.getMonitorDescriptor((EventMonitor)i.next(), count);
            ++count;
        }
        this.getUserTaskManager().setEnabled("DeleteMonitorButton", this.m_idMonitorList.length != 0);
        this.getUserTaskManager().setEnabled("EditMonitorButton", this.m_idMonitorList.length != 0);
        if (this.m_idMonitorList.length > 0) {
            int[] selection = new int[]{0};
            this.setMonitorListSelection(selection);
        } else {
            this.setMonitorListSelection(null);
        }
        this.getUserTaskManager().refreshAllElements();
    }

    private ItemDescriptor[] getMonitorDescriptor(EventMonitor monitor, int count) {
        ItemDescriptor name = new ItemDescriptor("monitorName" + count, monitor.getName());
        ItemDescriptor description = new ItemDescriptor("monitorDescription" + count, monitor.getDescription());
        ItemDescriptor enabled = new ItemDescriptor("monitorEnabled" + count, monitor.isEnabled() ? "true" : "false");
        ItemDescriptor[] result = new ItemDescriptor[]{name, description, enabled};
        return result;
    }
}

